/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IReloader;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IHandState;
import dev.toma.gunsrpg.api.common.data.IReloadInfo;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ReloadInfo
implements IReloadInfo {
    private final IAttributeRef attrRef;
    private final IHandState handState;
    private IReloader activeReloadManager = IReloader.EMPTY;
    private int reloadingSlot;

    public ReloadInfo(IAttributeRef attrRef, IHandState state) {
        this.attrRef = attrRef;
        this.handState = state;
    }

    @Override
    public void enqueueCancel() {
        this.activeReloadManager.enqueueCancel();
    }

    @Override
    public void tick(PlayerEntity player) {
        int equippedSlot = player.field_71071_by.field_70461_c;
        if (equippedSlot != this.reloadingSlot) {
            this.activeReloadManager.forceCancel();
            this.activeReloadManager = IReloader.EMPTY;
            this.handState.freeHands();
        }
        this.activeReloadManager.tick(player);
    }

    @Override
    public void startReloading(PlayerEntity player, GunItem gun, ItemStack stack, int slot) {
        AmmoType ammoType = gun.getAmmoType();
        IAmmoMaterial material = gun.getMaterialFromNBT(stack);
        if (material != null && (player.func_184812_l_() || ItemLocator.contains((IInventory)player.field_71071_by, ItemLocator.filterByAmmoTypeAndMaterial(ammoType, material)))) {
            this.activeReloadManager = gun.getReloadManager(player, this.attrRef.getProviderReference()).createReloadHandler();
            this.activeReloadManager.initiateReload(player, gun, stack);
            this.reloadingSlot = slot;
            this.handState.setHandsBusy();
        }
    }

    @Override
    public boolean isReloading() {
        return this.activeReloadManager.isReloading();
    }

    @FunctionalInterface
    public static interface IAttributeRef {
        public IAttributeProvider getProviderReference();
    }
}

